/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.preferences;

import com.aptana.editor.common.preferences.CommonEditorPreferencePage;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.editor.ruby.RubySourceEditor;
import com.aptana.editor.ruby.preferences.Messages;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class RubyPreferencePage
extends CommonEditorPreferencePage {
    private BooleanFieldEditor foldComments;
    private BooleanFieldEditor foldMethods;
    private BooleanFieldEditor foldBlocks;
    private BooleanFieldEditor foldInnerTypes;
    private Composite foldingGroup;

    public RubyPreferencePage() {
        this.setDescription(Messages.RubyPreferencePage_Ruby_Page_Title);
        this.setPreferenceStore(RubyEditorPlugin.getDefault().getPreferenceStore());
    }

    protected IEclipsePreferences getPluginPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("com.aptana.editor.ruby");
    }

    protected IPreferenceStore getChainedEditorPreferenceStore() {
        return RubySourceEditor.getChainedPreferenceStore();
    }

    protected IEclipsePreferences getDefaultPluginPreferenceStore() {
        return DefaultScope.INSTANCE.getNode("com.aptana.editor.ruby");
    }

    protected boolean getDefaultSpacesForTabs() {
        return true;
    }

    protected int getDefaultTabWidth() {
        return 2;
    }

    protected Composite createFoldingOptions(Composite parent) {
        this.foldingGroup = super.createFoldingOptions(parent);
        Label initialFoldLabel = new Label(this.foldingGroup, 64);
        initialFoldLabel.setText(Messages.RubyPreferencePage_initial_fold_options_label);
        this.foldComments = new BooleanFieldEditor("fold_comments", Messages.RubyPreferencePage_fold_comments_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldComments);
        this.foldMethods = new BooleanFieldEditor("fold_methods", Messages.RubyPreferencePage_fold_methods_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldMethods);
        this.foldInnerTypes = new BooleanFieldEditor("fold_inner_types", Messages.RubyPreferencePage_fold_inner_types_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldInnerTypes);
        this.foldBlocks = new BooleanFieldEditor("fold_blocks", Messages.RubyPreferencePage_fold_blocks_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldBlocks);
        return this.foldingGroup;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(this.enableFolding)) {
            boolean optionsEnabled = false;
            Object newValue = event.getNewValue();
            if (Boolean.TRUE.equals(newValue)) {
                optionsEnabled = true;
            }
            this.foldComments.setEnabled(optionsEnabled, this.foldingGroup);
            this.foldMethods.setEnabled(optionsEnabled, this.foldingGroup);
            this.foldBlocks.setEnabled(optionsEnabled, this.foldingGroup);
            this.foldInnerTypes.setEnabled(optionsEnabled, this.foldingGroup);
        }
        super.propertyChange(event);
    }
}

